/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationList;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.engine.Schedule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;

public class AnimationList<A extends IAnimation>
implements IAnimationList<A> {
    private final List<A> animations = new LinkedList<A>();
    private final List<Schedule<ListAnimationSchedule<A>>> schedules = new ArrayList<Schedule<ListAnimationSchedule<A>>>();
    private int runningAnimations;

    protected AnimationList(PlayerEntity player) {
    }

    public static <A extends IAnimation> AnimationList<A> newList(PlayerEntity player) {
        return new AnimationList<A>(player);
    }

    public static <A extends IAnimation, L extends AnimationList<A>> L schedule(AnimationType<L> listAnimationType, A animation, int scheduleIn) {
        L list = AnimationList.getOrCreateAnimationList(listAnimationType);
        ((AnimationList)list).schedule(scheduleIn, animation);
        return list;
    }

    public static <A extends IAnimation, L extends AnimationList<A>> L enqueue(AnimationType<L> listAnimationType, A animation) {
        L list = AnimationList.getOrCreateAnimationList(listAnimationType);
        ((AnimationList)list).enqueue(animation);
        return list;
    }

    public static <L extends AnimationList<?>> L getOrCreateAnimationList(AnimationType<L> type) {
        AnimationList list;
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        boolean exists = pipeline.has(type);
        if (exists) {
            list = (AnimationList)pipeline.get(type);
        } else {
            ClientPlayerEntity client = Minecraft.func_71410_x().field_71439_g;
            list = (AnimationList)type.create((PlayerEntity)client);
            pipeline.insert(type, list);
        }
        return (L)list;
    }

    @Override
    public void enqueue(A animation) {
        this.animations.add(animation);
        ++this.runningAnimations;
    }

    public <L extends AnimationList<A>> void schedule(int ticks, A animation) {
        Supplier<ListAnimationSchedule> animationSchedule = () -> new ListAnimationSchedule<IAnimation>((IAnimation)animation);
        Schedule<ListAnimationSchedule> schedule = new Schedule<ListAnimationSchedule>(ticks, animationSchedule);
        this.schedules.add(schedule);
    }

    @Override
    public int size() {
        return this.runningAnimations;
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        for (IAnimation anim : this.animations) {
            anim.animate(stage, matrixStack, typeBuffer, light, overlay);
        }
    }

    @Override
    public void gameTick() {
        this.tickSchedules();
        Iterator<A> iterator = this.animations.iterator();
        while (iterator.hasNext()) {
            IAnimation animation = (IAnimation)iterator.next();
            if (animation.hasFinished()) {
                iterator.remove();
                --this.runningAnimations;
            }
            animation.gameTick();
        }
    }

    @Override
    public void renderTick(float deltaRenderTime) {
        for (IAnimation anim : this.animations) {
            anim.renderTick(deltaRenderTime);
        }
    }

    @Override
    public boolean hasFinished() {
        return this.schedules.isEmpty() && this.runningAnimations == 0;
    }

    private void tickSchedules() {
        Iterator<Schedule<ListAnimationSchedule<A>>> iterator = this.schedules.iterator();
        while (iterator.hasNext()) {
            Schedule<ListAnimationSchedule<A>> schedule = iterator.next();
            if (schedule.done()) {
                ListAnimationSchedule<A> listSchedule = schedule.get();
                IAnimation animation = ((ListAnimationSchedule)listSchedule).animation;
                this.enqueue(animation);
                iterator.remove();
                continue;
            }
            schedule.update();
        }
    }

    private static class ListAnimationSchedule<A extends IAnimation> {
        private final A animation;

        public ListAnimationSchedule(A animation) {
            this.animation = animation;
        }
    }
}

